/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph.spi;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.CannotBecomeEntityGraphException;
import org.hibernate.graph.CannotContainSubGraphException;
import org.hibernate.graph.Graph;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.graph.spi.GraphNodeImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;

public interface GraphImplementor<J>
extends Graph<J>,
GraphNodeImplementor<J> {
    public boolean appliesTo(ManagedDomainType<? super J> var1);

    public boolean appliesTo(Class<? super J> var1);

    public void merge(GraphImplementor<J> ... var1);

    public JpaMetamodel jpaMetamodel();

    @Override
    public RootGraphImplementor<J> makeRootGraph(String var1, boolean var2) throws CannotBecomeEntityGraphException;

    @Override
    public SubGraphImplementor<J> makeSubGraph(boolean var1);

    @Override
    public GraphImplementor<J> makeCopy(boolean var1);

    default public void visitAttributeNodes(Consumer<AttributeNodeImplementor<?>> consumer) {
        this.getAttributeNodeImplementors().forEach(consumer);
    }

    public AttributeNodeImplementor<?> addAttributeNode(AttributeNodeImplementor<?> var1);

    public List<AttributeNodeImplementor<?>> getAttributeNodeImplementors();

    @Override
    default public List<AttributeNode<?>> getAttributeNodeList() {
        return this.getAttributeNodeImplementors();
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ> findAttributeNode(String var1);

    @Override
    public <AJ> AttributeNodeImplementor<AJ> findAttributeNode(PersistentAttribute<? extends J, AJ> var1);

    @Override
    public <AJ> AttributeNodeImplementor<AJ> addAttributeNode(String var1) throws CannotContainSubGraphException;

    @Override
    public <AJ> AttributeNodeImplementor<AJ> addAttributeNode(PersistentAttribute<? extends J, AJ> var1) throws CannotContainSubGraphException;

    default public <AJ> AttributeNodeImplementor<AJ> findOrCreateAttributeNode(String name) {
        return this.findOrCreateAttributeNode((PersistentAttribute<? extends J, AJ>)this.getGraphedType().getAttribute(name));
    }

    public <AJ> AttributeNodeImplementor<AJ> findOrCreateAttributeNode(PersistentAttribute<? extends J, AJ> var1);

    @Override
    default public <AJ> SubGraphImplementor<AJ> addSubGraph(String attributeName) throws CannotContainSubGraphException {
        return this.findOrCreateAttributeNode(attributeName).makeSubGraph();
    }

    @Override
    default public <AJ> SubGraphImplementor<AJ> addSubGraph(String attributeName, Class<AJ> subType) throws CannotContainSubGraphException {
        return this.findOrCreateAttributeNode(attributeName).makeSubGraph(subType);
    }

    @Override
    default public <AJ> SubGraphImplementor<AJ> addSubGraph(PersistentAttribute<? extends J, AJ> attribute) throws CannotContainSubGraphException {
        return this.findOrCreateAttributeNode(attribute).makeSubGraph();
    }

    @Override
    default public <AJ> SubGraphImplementor<? extends AJ> addSubGraph(PersistentAttribute<? extends J, AJ> attribute, Class<? extends AJ> subType) throws CannotContainSubGraphException {
        return this.findOrCreateAttributeNode(attribute).makeSubGraph(subType);
    }

    @Override
    default public <AJ> SubGraphImplementor<AJ> addKeySubGraph(String attributeName) {
        return this.findOrCreateAttributeNode(attributeName).makeKeySubGraph();
    }

    @Override
    default public <AJ> SubGraphImplementor<AJ> addKeySubGraph(String attributeName, Class<AJ> subtype) {
        return this.findOrCreateAttributeNode(attributeName).makeKeySubGraph(subtype);
    }

    @Override
    default public <AJ> SubGraphImplementor<AJ> addKeySubGraph(PersistentAttribute<? extends J, AJ> attribute) {
        return this.findOrCreateAttributeNode(attribute).makeKeySubGraph();
    }

    @Override
    default public <AJ> SubGraphImplementor<? extends AJ> addKeySubGraph(PersistentAttribute<? extends J, AJ> attribute, Class<? extends AJ> subType) throws CannotContainSubGraphException {
        return this.findOrCreateAttributeNode(attribute).makeKeySubGraph(subType);
    }
}

