/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.Consumer;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.AbstractEmbeddableMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.IdClassRepresentationStrategy;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.MutableAttributeMappingList;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.internal.VirtualIdEmbeddable;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.CompositeTypeImplementor;

public class IdClassEmbeddable
extends AbstractEmbeddableMapping
implements NonAggregatedIdentifierMapping.IdentifierValueMapper {
    private final NavigableRole navigableRole;
    private final NonAggregatedIdentifierMapping idMapping;
    private final VirtualIdEmbeddable virtualIdEmbeddable;
    private final JavaType<?> javaType;
    private final IdClassRepresentationStrategy representationStrategy;
    private final EmbeddableValuedModelPart embedded;

    public IdClassEmbeddable(Component idClassSource, RootClass bootEntityDescriptor, NonAggregatedIdentifierMapping idMapping, EntityMappingType identifiedEntityMapping, String idTable, String[] idColumns, VirtualIdEmbeddable virtualIdEmbeddable, MappingModelCreationProcess creationProcess) {
        super(new MutableAttributeMappingList(idClassSource.getPropertySpan()));
        this.navigableRole = idMapping.getNavigableRole().append("_identifierMapper");
        this.idMapping = idMapping;
        this.virtualIdEmbeddable = virtualIdEmbeddable;
        this.javaType = creationProcess.getCreationContext().getTypeConfiguration().getJavaTypeRegistry().resolveManagedTypeDescriptor(idClassSource.getComponentClass());
        this.representationStrategy = new IdClassRepresentationStrategy(this);
        PropertyAccess propertyAccess = PropertyAccessStrategyMapImpl.INSTANCE.buildPropertyAccess(null, "{id}", true);
        AttributeMetadata attributeMetadata = MappingModelCreationHelper.getAttributeMetadata(propertyAccess);
        this.embedded = new EmbeddedAttributeMapping("_identifierMapper", identifiedEntityMapping.getNavigableRole().append("{id}").append("_identifierMapper"), -1, -1, idTable, attributeMetadata, (PropertyAccess)null, FetchTiming.IMMEDIATE, FetchStyle.JOIN, (EmbeddableMappingType)this, (ManagedMappingType)identifiedEntityMapping, propertyAccess);
        CompositeType idClassType = idClassSource.getType();
        ((CompositeTypeImplementor)idClassType).injectMappingModelPart(this.embedded, creationProcess);
        creationProcess.registerInitializationCallback("IdClassEmbeddable(" + this.navigableRole.getFullPath() + ")#finishInitialization", () -> this.finishInitialization(idClassSource, idClassType, idTable, idColumns, creationProcess));
    }

    public IdClassEmbeddable(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, IdClassEmbeddable inverseMappingType, MappingModelCreationProcess creationProcess) {
        super(new MutableAttributeMappingList(inverseMappingType.attributeMappings.size()));
        this.navigableRole = inverseMappingType.getNavigableRole();
        this.idMapping = (NonAggregatedIdentifierMapping)((Object)valueMapping);
        this.virtualIdEmbeddable = (VirtualIdEmbeddable)valueMapping.getEmbeddableTypeDescriptor();
        this.javaType = inverseMappingType.javaType;
        this.representationStrategy = new IdClassRepresentationStrategy(this);
        this.embedded = valueMapping;
        this.selectableMappings = selectableMappings;
        creationProcess.registerInitializationCallback("IdClassEmbeddable(" + inverseMappingType.getNavigableRole().getFullPath() + ".{inverse})#finishInitialization", () -> this.inverseInitializeCallback(declaringTableGroupProducer, selectableMappings, inverseMappingType, creationProcess, this, this.attributeMappings));
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddedPart() {
        return this.embedded;
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        Object id = this.representationStrategy.getInstantiator().instantiate(null, session.getSessionFactory());
        Object[] propertyValues = new Object[this.virtualIdEmbeddable.getNumberOfAttributeMappings()];
        for (int i = 0; i < propertyValues.length; ++i) {
            AttributeMapping attributeMapping = this.virtualIdEmbeddable.getAttributeMapping(i);
            Object o = attributeMapping.getPropertyAccess().getGetter().get(entity);
            if (o == null) {
                AttributeMapping idClassAttributeMapping = this.getAttributeMapping(i);
                if (idClassAttributeMapping.getPropertyAccess().getGetter().getReturnTypeClass().isPrimitive()) {
                    propertyValues[i] = idClassAttributeMapping.getExpressibleJavaType().getDefaultValue();
                    continue;
                }
                propertyValues[i] = null;
                continue;
            }
            if (attributeMapping instanceof ToOneAttributeMapping && !(this.getAttributeMapping(i) instanceof ToOneAttributeMapping)) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
                ValuedModelPart targetPart = toOneAttributeMapping.getForeignKeyDescriptor().getPart(toOneAttributeMapping.getSideNature().inverse());
                if (targetPart.isEntityIdentifierMapping()) {
                    propertyValues[i] = ((EntityIdentifierMapping)targetPart).getIdentifier(o);
                    continue;
                }
                propertyValues[i] = o;
                assert (false);
                continue;
            }
            propertyValues[i] = o;
        }
        this.setValues(id, propertyValues);
        return id;
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        EntityPersister entityDescriptor = factory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entity.getClass());
        Object[] propertyValues = new Object[this.attributeMappings.size()];
        this.virtualIdEmbeddable.forEachAttribute((position, virtualIdAttribute) -> {
            AttributeMapping idClassAttribute = this.attributeMappings.get(position);
            Object o = idClassAttribute.getPropertyAccess().getGetter().get(id);
            if (virtualIdAttribute instanceof ToOneAttributeMapping && !(idClassAttribute instanceof ToOneAttributeMapping)) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)virtualIdAttribute;
                EntityPersister entityPersister = toOneAttributeMapping.getEntityMappingType().getEntityPersister();
                EntityKey entityKey = session.generateEntityKey(o, entityPersister);
                PersistenceContext persistenceContext = session.getPersistenceContext();
                propertyValues[position] = persistenceContext.getProxy(entityKey);
                if (propertyValues[position] == null) {
                    propertyValues[position] = persistenceContext.getEntity(entityKey);
                    if (propertyValues[position] == null) {
                        propertyValues[position] = entityDescriptor.getPropertyValue(entity, toOneAttributeMapping.getAttributeName());
                    }
                }
            } else {
                propertyValues[position] = o;
            }
        });
        this.virtualIdEmbeddable.setValues(entity, propertyValues);
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String getPartName() {
        return "_identifierMapper";
    }

    @Override
    public EmbeddableRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.javaType;
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddedValueMapping() {
        return this.embedded;
    }

    @Override
    public boolean isCreateEmptyCompositesEnabled() {
        return false;
    }

    @Override
    public void forEachAttributeMapping(Consumer<? super AttributeMapping> action) {
        this.forEachAttribute((index, attribute) -> action.accept((AttributeMapping)attribute));
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.idMapping.findContainingEntityMapping();
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EmbeddableMappingType createInverseMappingType(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, MappingModelCreationProcess creationProcess) {
        return new IdClassEmbeddable(valueMapping, declaringTableGroupProducer, selectableMappings, this, creationProcess);
    }

    private boolean finishInitialization(Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, MappingModelCreationProcess creationProcess) {
        this.attributeMappings.clear();
        return this.finishInitialization(this.navigableRole, bootDescriptor, compositeType, rootTableExpression, rootTableKeyColumnNames, this, this.representationStrategy, (attributeName, attributeType) -> {
            if (attributeType instanceof CollectionType) {
                throw new AbstractEmbeddableMapping.IllegalAttributeType("An IdClass cannot define collection attributes : " + attributeName);
            }
            if (attributeType instanceof AnyType) {
                throw new AbstractEmbeddableMapping.IllegalAttributeType("An IdClass cannot define <any/> attributes : " + attributeName);
            }
        }, (column, jdbcEnvironment) -> MappingModelCreationHelper.getTableIdentifierExpression(column.getValue().getTable(), creationProcess), this::addAttribute, () -> creationProcess.registerInitializationCallback("IdClassEmbeddable(" + this.getNavigableRole() + ")#initColumnMappings", this::initColumnMappings), creationProcess);
    }
}

