/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.Iterator;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupSingle;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class InsertRowsCoordinatorStandard
implements InsertRowsCoordinator {
    private final CollectionMutationTarget mutationTarget;
    private final RowMutationOperations rowMutationOperations;
    private final BasicBatchKey batchKey;
    private MutationOperationGroupSingle operationGroup;

    public InsertRowsCoordinatorStandard(CollectionMutationTarget mutationTarget, RowMutationOperations rowMutationOperations) {
        this.mutationTarget = mutationTarget;
        this.rowMutationOperations = rowMutationOperations;
        this.batchKey = new BasicBatchKey(mutationTarget.getRolePath() + "#INSERT");
    }

    public String toString() {
        return "InsertRowsCoordinator(" + this.mutationTarget.getRolePath() + ")";
    }

    @Override
    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRows(PersistentCollection<?> collection, Object id, InsertRowsCoordinator.EntryFilter entryChecker, SharedSessionContractImplementor session) {
        if (this.operationGroup == null) {
            this.operationGroup = this.createOperationGroup();
        }
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER_DEBUG_ENABLED) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Inserting collection rows - %s : %s", (Object)this.mutationTarget.getRolePath(), id);
        }
        PluralAttributeMapping pluralAttribute = this.mutationTarget.getTargetPart();
        CollectionPersister collectionDescriptor = pluralAttribute.getCollectionDescriptor();
        MutationExecutorService mutationExecutorService = session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        MutationExecutor mutationExecutor = mutationExecutorService.createExecutor(() -> this.batchKey, this.operationGroup, session);
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        try {
            Iterator<?> entries = collection.entries(collectionDescriptor);
            collection.preInsert(collectionDescriptor);
            if (!entries.hasNext()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("No collection rows to insert - %s : %s", (Object)this.mutationTarget.getRolePath(), id);
                return;
            }
            int entryCount = 0;
            RowMutationOperations.Values insertRowValues = this.rowMutationOperations.getInsertRowValues();
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (entryChecker == null || entryChecker.include(entry, entryCount, collection, pluralAttribute)) {
                    insertRowValues.applyValues(collection, id, entry, entryCount, session, jdbcValueBindings);
                    mutationExecutor.execute(entry, null, null, null, session);
                }
                ++entryCount;
            }
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Done inserting `%s` collection rows : %s", entryCount, (Object)this.mutationTarget.getRolePath());
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationOperationGroupSingle createOperationGroup() {
        assert (this.mutationTarget.getTargetPart() != null);
        assert (this.mutationTarget.getTargetPart().getKeyDescriptor() != null);
        JdbcMutationOperation operation = this.rowMutationOperations.getInsertRowOperation();
        return new MutationOperationGroupSingle(MutationType.INSERT, this.mutationTarget, operation);
    }
}

