/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class ArrayType
extends Type {
    private final Type component;
    private final int dimensions;
    private int hash;

    public static ArrayType create(Type component, int dimensions) {
        return new ArrayType(component, dimensions);
    }

    ArrayType(Type component, int dimensions) {
        this(component, dimensions, null);
    }

    ArrayType(Type component, int dimensions, AnnotationInstance[] annotations) {
        super(DotName.OBJECT_NAME, annotations);
        this.dimensions = dimensions;
        this.component = component;
    }

    public Type component() {
        return this.component;
    }

    @Override
    public DotName name() {
        StringBuilder builder = new StringBuilder();
        Type type = this;
        while (((Type)type).kind() == Type.Kind.ARRAY) {
            int dimensions = ((Type)type).asArrayType().dimensions;
            while (dimensions-- > 0) {
                builder.append('[');
            }
            type = ((Type)type).asArrayType().component;
        }
        if (((Type)type).kind() == Type.Kind.PRIMITIVE) {
            builder.append(type.asPrimitiveType().toCode());
        } else {
            builder.append('L').append(((Type)type).name().toString()).append(';');
        }
        return DotName.createSimple(builder.toString());
    }

    public int dimensions() {
        return this.dimensions;
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.ARRAY;
    }

    @Override
    public ArrayType asArrayType() {
        return this;
    }

    @Override
    Type copyType(AnnotationInstance[] newAnnotations) {
        return new ArrayType(this.component, this.dimensions, newAnnotations);
    }

    Type copyType(Type component, int dimensions) {
        return new ArrayType(component, dimensions, this.annotationArray());
    }

    @Override
    String toString(boolean simple) {
        StringBuilder builder = new StringBuilder();
        this.appendRootComponent(builder, true);
        this.appendArraySyntax(builder);
        return builder.toString();
    }

    private void appendRootComponent(StringBuilder builder, boolean simple) {
        if (this.component.kind() == Type.Kind.ARRAY) {
            this.component.asArrayType().appendRootComponent(builder, simple);
        } else {
            builder.append(this.component.toString(simple));
        }
    }

    private void appendArraySyntax(StringBuilder builder) {
        if (this.annotationArray().length > 0) {
            builder.append(' ');
            this.appendAnnotations(builder);
        }
        for (int i = 0; i < this.dimensions; ++i) {
            builder.append("[]");
        }
        if (this.component.kind() == Type.Kind.ARRAY) {
            this.component.asArrayType().appendArraySyntax(builder);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)o;
        return super.equals(o) && this.dimensions == arrayType.dimensions && this.component.equals(arrayType.component);
    }

    @Override
    public int hashCode() {
        int hash = this.hash;
        if (hash != 0) {
            return hash;
        }
        hash = super.hashCode();
        hash = 31 * hash + this.component.hashCode();
        this.hash = hash = 31 * hash + this.dimensions;
        return this.hash;
    }

    @Override
    public boolean internEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)o;
        return super.internEquals(o) && this.dimensions == arrayType.dimensions && this.component.internEquals(arrayType.component);
    }

    @Override
    public int internHashCode() {
        int hash = super.internHashCode();
        hash = 31 * hash + this.component.internHashCode();
        hash = 31 * hash + this.dimensions;
        return hash;
    }
}

